#include <Core/Core.h>
#include <SSH/SSH.h>

using namespace Upp;

// SFtpDir.cpp: 
// Demonstates remote directory listing via an sftp channel.

// A popular public test server:
// -----------------------------
// Host:     test.rebex.net
// User:     user
// Password: password
// Path:     pub/examples

CONSOLE_APP_MAIN
{
	Ssh session;
	Cout() << "Hostname: ";
	auto host = ReadStdIn();
	Cout() << "Username: ";
	auto user = ReadStdIn();
	Cout() << "Password: ";
	auto pass = ReadStdIn();
	Cout() << "Path: ";
	auto path = ReadStdIn();
	const int port = 22;

	if(session.Connect(host, port, user, pass)) {
		SFtp sftp(session);
		SFtp::DirList ls;
		if(!sftp.ListDir(path, ls)) Exit(sftp.GetError());
		for(auto& e : ls)  Cout() << e.GetEntry() << "\n";
	}
	else Cerr() << session.GetErrorDesc() << '\n';
}